Attribute VB_Name = "Common_DB_Application"
Public Function SendMessage(ai_MsgCode As Integer, as_MsgDefault As String, as_LanguageCode As String, Optional Buttons As VbMsgBoxStyle = vbOKOnly, Optional Title, Optional lb_Use_NCS_ODBC As Boolean = False, Optional ByVal aInfo As Variant) As VbMsgBoxResult
'------------------------------------------------------------------
' Name : SendMessage
'
' Purpose : Read the message in the database with MsgText and
'           ask/say to the user. If the message does'nt exist in the
'           database, the default message is used
'
' Parameters :
'       ai_MsgCode          Code of the message to find in the
'                               database
'       as_MsgDefault       Default Message to use if we can't
'                               find in the database
'       as_LanguageCode     The language to use for the text
'       Buttons (Optional)  Indicates the buttons to use
'       Title (Optional)    Indicates the Title to use
'       ab_Use_NCS_ODBC     Use the NCS ODBC method (false by default)
'
' Return :
'       The button used to quit the message box
'
' review : Jan/06/2000 by AD
'------------------------------------------------------------------
Dim ll_Mouse As Long
Dim lo_Return As VbMsgBoxResult

    gs_message = MsgText(ai_MsgCode, as_LanguageCode, lb_Use_NCS_ODBC)
    If gs_message = "" Then
        gs_message = as_MsgDefault
    End If
    
    'We read the actual status of the mouse pointer
    ll_Mouse = Screen.MousePointer
    
    'Turn the mouse pointer to arrow
    MouseOn
    
    'replace placeholders   JN 26/04/2019
    Dim li_idx As Integer
    If Not IsMissing(aInfo) Then
        For li_idx = 0 To UBound(aInfo)
            gs_message = Replace(gs_message, aInfo(li_idx, 0), aInfo(li_idx, 1), , , vbTextCompare)
        Next li_idx
    End If
    
    If IsMissing(Title) Then
        lo_Return = MsgBox(gs_message, Buttons)
    Else
        lo_Return = MsgBox(gs_message, Buttons, Title)
    End If
    
    'Turn the mouse pointer to the old status
    If ll_Mouse = 11 Then
        MouseOff
    End If

    SendMessage = lo_Return

End Function

Public Function InputMessage(li_MsgCode As Integer, ls_MsgDefault As String, Optional Title, Optional lb_Use_NCS_ODBC As Boolean = False) As String
'------------------------------------------------------------------
' Name : InputMessage
'
' Purpose : Read the message in the database with MsgText and
'           ask/say to the user. If the message does'nt exist in the
'           database, the default message is used. The user can
'           also write his information
'
' Parameters :
'       li_MsgCode          Code of the message to find in the
'                               database
'       ls_MsgDefault       Default Message to use if we can't
'                               find in the database
'       Title (Optional)    Indicates the Title to use
'       ab_Use_NCS_ODBC     Use the NCS ODBC method (false by default)
'
' Return :
'       The user's information
'
' review : Sep/14/2000 by AD
'------------------------------------------------------------------
Dim ll_Mouse As Long
Dim ls_Return As String

    gs_message = MsgText(li_MsgCode, gut_LangLogin.Code, lb_Use_NCS_ODBC)
    If gs_message = "" Then
        gs_message = ls_MsgDefault
    End If
    
    'We read the actual status of the mouse pointer
    ll_Mouse = Screen.MousePointer
    
    'Turn the mouse pointer to arrow
    MouseOn
    
    If IsMissing(Title) Then
        ls_Return = InputBox(gs_message)
    Else
        ls_Return = InputBox(gs_message, Title)
    End If
    
    'Turn the mouse pointer to the old status
    If ll_Mouse = 11 Then
        MouseOff
    End If

    InputMessage = ls_Return

End Function

Public Function MsgText(ai_MsgID As Integer, as_LanguageCode As String, Optional lb_Use_NCS_ODBC As Boolean = False) As String
'------------------------------------------------------------------
' Name : MsgText
'
' Purpose : Read the message in the database with the login
'           language
'
' Parameters :
'       ai_MsgId            Code of the message to find in the
'                               database
'       as_LanguageCode     Language Code to use to find the text
'       ab_Use_NCS_ODBC     Use the NCS ODBC method (false by default)
'
' Return :
'       The message in the good language
'
' review : Mar/20/2000 by AD
'------------------------------------------------------------------
Dim ls_req As String
Dim ll_Statement As Long
Dim li_Status As Integer
   
    ls_req = "SELECT message_text FROM error_message " _
        & " WHERE msgid = " & ai_MsgID _
        & " AND Language_code = '" _
        & as_LanguageCode & "'"
    
        
    If lb_Use_NCS_ODBC = True Then
        On Error GoTo msgtext_err1
    
        If NCS_Submit(ll_Statement, ls_req) Then
            li_Status = SQL_SUCCESS
            Do While li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO
            ' Get the row of data
                li_Status = NCS_Fetch(ll_Statement)
                If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then
                    MsgText = NCS_GetData(ll_Statement, 1)
                End If
            Loop
            li_Status = NCS_FreeStatement(ll_Statement, SQL_DROP)
        End If
    
    Else
        On Error GoTo MsgText_Err
    
    If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_req) Then
        li_Status = SQL_SUCCESS
        Do While li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO
        ' Get the row of data
            li_Status = SQLFetch(ll_Statement)
            If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then
                MsgText = ODBCData(ll_Statement, 1)
            End If
        Loop
        li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    End If
    End If
    Exit Function

MsgText_Err:
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    StdError
    Exit Function
msgtext_err1:
    li_Status = NCS_FreeStatement(ll_Statement, SQL_DROP)
    StdError
    Exit Function
End Function

Public Sub WriteUserEvent(ls_Event As String, Optional lb_Use_NCS_ODBC As Boolean = False)
'------------------------------------------------------------------
' Name : WriteUserEvent
'
' Purpose : Write an event to the database for the current user
'
' Parameters :
'       ls_Event            Event to write
'       ab_Use_NCS_ODBC     Use the NCS ODBC method (false by default)
'
' Return : Nothing
'
' review : Mar/29/2000 by AD
'------------------------------------------------------------------
Dim ll_Statement As Long
Dim li_Status As Integer
Dim ls_req As String

    ls_req = "EXEC User_Log_Ins '" _
        & App.ProductName & "', '" _
        & gs_Sifyb0Version & "', '" _
        & App.Major & "." & App.Minor & "." & App.Revision & "', '" _
        & gs_IniVersion & "', '" _
        & ls_Event & "' "
    
    If lb_Use_NCS_ODBC = True Then
        On Error GoTo WriteUserEvent_Err1
    
        li_Status = NCS_Submit(ll_Statement, ls_req)
        li_Status = NCS_FreeStatement(ll_Statement, SQL_DROP)
        
        If gl_CodeComputer <> 0 Then
            ls_req = "EXEC s0_historic_Connection_ins " _
                & CStr(gl_CodeComputer) & ",'" _
                & ls_Event & "',' " _
                & gs_IniVersion & "', '" _
                & gs_Sifyb0Version & "', '" _
                & App.Major & "." & App.Minor & "." & App.Revision & "'"
            li_Status = NCS_Submit(ll_Statement, ls_req)
            li_Status = NCS_FreeStatement(ll_Statement, SQL_DROP)
        End If
    Else
        On Error GoTo WriteUserEvent_Err
    
    li_Status = SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_req)
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    
    If gl_CodeComputer <> 0 Then
        ls_req = "EXEC s0_historic_Connection_ins " _
            & CStr(gl_CodeComputer) & ",'" _
            & ls_Event & "',' " _
            & gs_IniVersion & "', '" _
            & gs_Sifyb0Version & "', '" _
            & App.Major & "." & App.Minor & "." & App.Revision & "'"
        li_Status = SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_req)
        li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    End If
    End If
    Exit Sub

WriteUserEvent_Err:
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    StdError
    Exit Sub
WriteUserEvent_Err1:
    li_Status = NCS_FreeStatement(ll_Statement, SQL_DROP)
    StdError
    Exit Sub
End Sub

Function ZLogIns(ls_Text As String, Optional ls_Application = "", Optional lb_Use_NCS_ODBC As Boolean = False) As Boolean
'------------------------------------------------------------------
' Name : ZLogIns
'
' Purpose : Write an error to the database on the table zlog for
'           the current application
'
' Parameters :
'       ls_Text             Text to write on the table
'       ls_Application      Name of the application to associate
'                           with the text
'       ab_Use_NCS_ODBC     Use the NCS ODBC method (false by default)
'
' Return : KO on error or OK
'
' review : Apr/06/2000 by AD
'------------------------------------------------------------------
Dim ls_req As String
Dim li_Status As Integer
Dim ll_Statement As Long

    ZLogIns = KO
    
    ls_req = "EXEC ZLog_Ins2 '" & ls_Application & "','" & QuoteParam(ls_Text) & "',NULL"
        
    If lb_Use_NCS_ODBC = True Then
        On Error GoTo ZLogIns_Err1
        
        If NCS_Submit(ll_Statement, ls_req) = KO Then
            GoTo ZLogIns_Err
        End If
            
        li_Status = NCS_FreeStatement(ll_Statement, SQL_DROP)
    Else
        On Error GoTo ZLogIns_Err
        
    If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_req) = KO Then
        GoTo ZLogIns_Err
    End If
        
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    End If
    ZLogIns = OK
    
    Exit Function
    
ZLogIns_Err:
    li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    Exit Function
ZLogIns_Err1:
    li_Status = NCS_FreeStatement(ll_Statement, SQL_DROP)
    Exit Function
End Function

Public Sub ScreenConstants(ByRef ao_Form As Object, ByVal as_ScreenName As String, ByVal as_LanguageCode As String, Optional ab_Use_NCS_ODBC As Boolean = False)
'------------------------------------------------------------------
' Name : ScreenConstants
'
' Purpose : Fill the screen constants read in the database
'
' Parameters :
'       ao_Form             The form/User Control to fill
'       as_ScreenName       The name of the screen in the database
'       as_LanguageCode     The language code to use to retrieve the information
'       ab_Use_NCS_ODBC     Use the NCS ODBC method (false by default)
'
' Return : Nothing
'
' review : Apr/19/2000 by AD
'------------------------------------------------------------------
Dim ll_Statement As Long
Dim ls_Request As String
Dim la_Name() As String
Dim la_Strings() As String
Dim li_Number As Integer
Dim li_Status As Integer
Dim i, j As Integer
Dim ls_Result As String

    ls_Request = "EXEC Screen_Csts '" & as_ScreenName & "','" & as_LanguageCode & "'"
    If ab_Use_NCS_ODBC = True Then
        li_Status = NCS_Submit(ll_Statement, ls_Request)
    Else
        li_Status = SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_Request)
    End If
    
    li_Number = 0
    If ab_Use_NCS_ODBC = True Then
        li_Status = NCS_Fetch(ll_Statement)
    Else
        li_Status = SQLFetch(ll_Statement)
    End If
    Do While li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO
        li_Number = li_Number + 1
        ReDim Preserve la_Name(li_Number) As String
        ReDim Preserve la_Strings(li_Number) As String
        
        If ab_Use_NCS_ODBC = True Then
            la_Name(li_Number) = NCS_GetData(ll_Statement, 1)
            la_Strings(li_Number) = NCS_GetData(ll_Statement, 2)
        
            li_Status = NCS_Fetch(ll_Statement)
        Else
            la_Name(li_Number) = ODBCData(ll_Statement, 1)
            la_Strings(li_Number) = ODBCData(ll_Statement, 2)
            
            li_Status = SQLFetch(ll_Statement)
        End If
    Loop
    
    If ab_Use_NCS_ODBC = True Then
        NCS_FreeStatement ll_Statement, SQL_DROP
    Else
        SQLFreeStatement ll_Statement, SQL_DROP
    End If
    
    If TypeOf ao_Form Is Form Then
        ao_Form.Caption = ScreenConstantsSearch(la_Name, la_Strings, "Title", "")
    End If
    
    If TypeName(ao_Form) = "UC_G_Main" Then
        For j = 0 To ao_Form.NbColumn - 1
            ao_Form.LabelColumn(j + 1) = ScreenConstantsSearch(la_Name, la_Strings, "c" & CStr(j), ao_Form.LabelColumn(j + 1))
        Next
        ao_Form.LabelDescription = ScreenConstantsSearch(la_Name, la_Strings, "lbl_Description", ao_Form.LabelDescription)
        ao_Form.LabelSearchText = ScreenConstantsSearch(la_Name, la_Strings, "lbl_SearchText", ao_Form.LabelSearchText)
        ao_Form.LabelSearchButton = ScreenConstantsSearch(la_Name, la_Strings, "lbl_SearchButton", ao_Form.LabelSearchButton)
        ao_Form.LabelNbOfRows = ScreenConstantsSearch(la_Name, la_Strings, "lbl_record", ao_Form.LabelNbOfRows)
        ao_Form.ChangeScreenConstants
    Else
        For i = 0 To ao_Form.Controls.Count - 1
            If TypeName(ao_Form.Controls(i)) = "UC_G_Main" Then
                For j = 0 To ao_Form.Controls(i).NbColumn - 1
                    ao_Form.Controls(i).LabelColumn(j + 1) = ScreenConstantsSearch(la_Name, la_Strings, "c" & CStr(j), ao_Form.Controls(i).LabelColumn(j + 1))
                Next
                ao_Form.Controls(i).LabelDescription = ScreenConstantsSearch(la_Name, la_Strings, "lbl_Description", ao_Form.Controls(i).LabelDescription)
                ao_Form.Controls(i).LabelSearchText = ScreenConstantsSearch(la_Name, la_Strings, "lbl_SearchText", ao_Form.Controls(i).LabelSearchText)
                ao_Form.Controls(i).LabelSearchButton = ScreenConstantsSearch(la_Name, la_Strings, "lbl_SearchButton", ao_Form.Controls(i).LabelSearchButton)
                ao_Form.Controls(i).LabelNbOfRows = ScreenConstantsSearch(la_Name, la_Strings, "lbl_record", ao_Form.Controls(i).LabelNbOfRows)
                ao_Form.Controls(i).ChangeScreenConstants
            Else
                ls_Result = ScreenConstantsSearch(la_Name, la_Strings, ao_Form.Controls(i).Name, "")
                If ls_Result <> "" Then
                    Select Case TypeName(ao_Form.Controls(i))
                        Case "Label", "OptionButton", "CheckBox", "Frame", "CommandButton"
                            ao_Form.Controls(i).Caption = ls_Result
                        Case "TextBox"
                            ao_Form.Controls(i).Text = ls_Result
                    End Select
                End If
            End If
            
        Next
    End If
End Sub

Private Function ScreenConstantsSearch(aa_Name() As String, aa_Strings() As String, as_Name As String, as_Default As String) As String
'------------------------------------------------------------------
' Name : ScreenConstantsSearch
'
' Purpose : Search a screen constant in the screen constant table
'
' Parameters :
'       aa_Name             Names of the screen constants
'       aa_Strings          Values of the screen constants
'       as_Name             Name to search
'       as_Default          Default value to return
'
' Return : The value of the screen constants
'
' review : Apr/19/2000 by AD
'------------------------------------------------------------------
Dim i As Integer
Dim li_Number As String

    On Error GoTo ScreenConstantsSearch_Err
    
    ScreenConstantsSearch = as_Default

    li_Number = UBound(aa_Name)

    i = 1
    Do While i <= li_Number
        If StrComp(aa_Name(i), as_Name, vbTextCompare) = 0 Then
            ScreenConstantsSearch = aa_Strings(i)
            Exit Function
        End If
        i = i + 1
    Loop
    
ScreenConstantsSearch_Err:
End Function

Public Sub Fill_AD_MultiCombo(ao_cbo As Object, as_Request As String, Optional ab_Use_NCS_ODBC As Boolean = False)
'------------------------------------------------------------------
' Name : Fill_AD_MultiCombo
'
' Purpose : Fill a combobox with the request send as parameter.
'
' Parameters :
'       ao_cbo          The comboBox
'       as_Request      The request that send the data
'       ab_Use_NCS_ODBC Use the NCS ODBC method (false by default)
'
' Return : Nothing
'
' review : 25/Apr/2001 by AD
'------------------------------------------------------------------
Dim ll_Statement As Long
Dim li_Status As Integer
Dim ls_Code As String
Dim ls_Description As String
Dim li_colNumber As Integer
Dim lb_Result As Boolean
Dim li_Position As Integer
Dim i As Integer

    On Error GoTo Fill_AD_MultiCombo_Err
    
    If ab_Use_NCS_ODBC = True Then
        lb_Result = NCS_Submit(ll_Statement, as_Request)
    Else
        lb_Result = SQLSubmit(gl_Environment, gl_Database, ll_Statement, as_Request)
    End If
    
    If lb_Result = True Then
    
        li_Status = SQL_SUCCESS
        If ab_Use_NCS_ODBC = True Then
            li_colNumber = NCS_NumResultCols(ll_Statement)
        Else
            SQLNumResultCols ll_Statement, li_colNumber
        End If
        
        Do While li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO
            If ab_Use_NCS_ODBC = True Then
                li_Status = NCS_Fetch(ll_Statement)
            Else
                li_Status = SQLFetch(ll_Statement)
            End If
            
            If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then
                
                If ab_Use_NCS_ODBC = True Then
                    ls_Code = NCS_GetData(ll_Statement, 1)
                    ls_Description = NCS_GetData(ll_Statement, 2)
                Else
                    ls_Code = ODBCData(ll_Statement, 1)
                    ls_Description = ODBCData(ll_Statement, 2)
                End If
            
                li_Position = ao_cbo.AddItem(False, ls_Code, ls_Description)
                
                i = 2
                Do While i <= li_colNumber
                    If ab_Use_NCS_ODBC = True Then
                        ao_cbo.Column(i - 2, li_Position) = NCS_GetData(ll_Statement, i + 1)
                    Else
                        ao_cbo.Column(i - 2, li_Position) = ODBCData(ll_Statement, i + 1)
                    End If
                    i = i + 1
                Loop
                    
            End If
        Loop
    End If
    If ab_Use_NCS_ODBC = True Then
        li_Status = NCS_FreeStatement(ll_Statement, SQL_DROP)
    Else
        li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    End If
    Exit Sub
    
Fill_AD_MultiCombo_Err:
    If ab_Use_NCS_ODBC = True Then
        li_Status = NCS_FreeStatement(ll_Statement, SQL_DROP)
    Else
        li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    End If
    StdError
End Sub

Public Function Load_AD_MultiCombo(ao_AD_MultiCombo As Object, as_Request As String, Optional ab_Use_NCS_ODBC As Boolean = False)
Dim lv_Code As Variant

    If ao_AD_MultiCombo.Tag = UNLOADED Then
        lv_Code = ao_AD_MultiCombo.Code
        ao_AD_MultiCombo.Clear
        Fill_AD_MultiCombo ao_AD_MultiCombo, as_Request, ab_Use_NCS_ODBC
        ao_AD_MultiCombo.CodeSelect = lv_Code
        ao_AD_MultiCombo.Tag = Loaded
    End If

End Function

Public Sub Init_AD_MultiCombo(ao_cbo As Object, al_statement As Long, ai_CodeColumn As Integer, ai_DescColumn As Integer, Optional ab_Use_NCS_ODBC As Boolean = False)
'------------------------------------------------------------------
' Name : Fill_AD_MultiCombo
'
' Purpose : Fill a combobox with the request send as parameter.
'
' Parameters :
'       ao_cbo          The comboBox
'       al_Statement    The statement of the database connection
'       ai_CodeColumn   The ODBC Column of the code
'       ai_DescColumn   The ODBC Column of the desc
'       ab_Use_NCS_ODBC Use the NCS ODBC method (false by default)
'
' Return : Nothing
'
' review : 25/Apr/2001 by AD
'------------------------------------------------------------------
Dim ls_Code As String
Dim ls_Desc As String

    On Error GoTo Init_AD_MultiCombo_Err
    
    If ab_Use_NCS_ODBC = True Then
        ls_Code = NCS_GetData(al_statement, ai_CodeColumn)
        ls_Desc = NCS_GetData(al_statement, ai_DescColumn)
    Else
        ls_Code = ODBCData(al_statement, ai_CodeColumn)
        ls_Desc = ODBCData(al_statement, ai_DescColumn)
    End If
    
    If ls_Code <> "" Then
        ao_cbo.AddItem True, ls_Code, ls_Desc
    End If
    
    Exit Sub
    
Init_AD_MultiCombo_Err:
    StdError
End Sub

Public Sub Fill_AD_MultiList(ao_List As Object, as_Request As String, Optional ab_Use_NCS_ODBC As Boolean = False)
'------------------------------------------------------------------
' Name : Fill_AD_MultiList
'
' Purpose : Fill a listbox with the request send as parameter.
'
' Parameters :
'       ao_List         The listbox
'       as_Request      The request that send the data
'       ab_Use_NCS_ODBC Use the NCS ODBC method (false by default)
'
' Return : Nothing
'
' review : 27/Apr/2001 by AD
'------------------------------------------------------------------
Dim ll_Statement As Long
Dim li_Status As Integer
Dim ls_Code As String
Dim ls_Description As String
Dim li_colNumber As Integer
Dim lb_Result As Boolean
Dim li_Position As Integer
Dim i As Integer

    On Error GoTo Fill_AD_MultiList_Err
    
    If ab_Use_NCS_ODBC = True Then
        lb_Result = NCS_Submit(ll_Statement, as_Request)
    Else
        lb_Result = SQLSubmit(gl_Environment, gl_Database, ll_Statement, as_Request)
    End If
    
    If lb_Result = True Then
    
        li_Status = SQL_SUCCESS
        If ab_Use_NCS_ODBC = True Then
            li_colNumber = NCS_NumResultCols(ll_Statement)
        Else
            SQLNumResultCols ll_Statement, li_colNumber
        End If
        
        Do While li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO
            If ab_Use_NCS_ODBC = True Then
                li_Status = NCS_Fetch(ll_Statement)
            Else
                li_Status = SQLFetch(ll_Statement)
            End If
            
            If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then
                
                If ab_Use_NCS_ODBC = True Then
                    ls_Code = NCS_GetData(ll_Statement, 1)
                    ls_Description = NCS_GetData(ll_Statement, 2)
                Else
                    ls_Code = ODBCData(ll_Statement, 1)
                    ls_Description = ODBCData(ll_Statement, 2)
                End If
            
                li_Position = ao_List.AddItem(False, ls_Code, ls_Description)
                
                i = 2
                Do While i <= li_colNumber
                    If ab_Use_NCS_ODBC = True Then
                        ao_List.Column(i - 2, li_Position) = NCS_GetData(ll_Statement, i + 1)
                    Else
                        ao_List.Column(i - 2, li_Position) = ODBCData(ll_Statement, i + 1)
                    End If
                    i = i + 1
                Loop
                    
            End If
        Loop
    End If
    If ab_Use_NCS_ODBC = True Then
        li_Status = NCS_FreeStatement(ll_Statement, SQL_DROP)
    Else
        li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    End If
    Exit Sub
    
Fill_AD_MultiList_Err:
    If ab_Use_NCS_ODBC = True Then
        li_Status = NCS_FreeStatement(ll_Statement, SQL_DROP)
    Else
        li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    End If
    StdError
End Sub



